// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.Communication.RouterWorkerOfferRevoked event. </summary>
    public partial class AcsRouterWorkerOfferRevokedEventData : AcsRouterWorkerEventData
    {
        /// <summary> Initializes a new instance of <see cref="AcsRouterWorkerOfferRevokedEventData"/>. </summary>
        internal AcsRouterWorkerOfferRevokedEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AcsRouterWorkerOfferRevokedEventData"/>. </summary>
        /// <param name="jobId"> Router Event Job ID. </param>
        /// <param name="channelReference"> Router Event Channel Reference. </param>
        /// <param name="channelId"> Router Event Channel ID. </param>
        /// <param name="workerId"> Router Worker events Worker Id. </param>
        /// <param name="queueId"> Router Worker Offer Revoked Queue Id. </param>
        /// <param name="offerId"> Router Worker Offer Revoked Offer Id. </param>
        internal AcsRouterWorkerOfferRevokedEventData(string jobId, string channelReference, string channelId, string workerId, string queueId, string offerId) : base(jobId, channelReference, channelId, workerId)
        {
            QueueId = queueId;
            OfferId = offerId;
        }

        /// <summary> Router Worker Offer Revoked Queue Id. </summary>
        public string QueueId { get; }
        /// <summary> Router Worker Offer Revoked Offer Id. </summary>
        public string OfferId { get; }
    }
}
