// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(AcsRouterWorkerDeregisteredEventDataConverter))]
    public partial class AcsRouterWorkerDeregisteredEventData
    {
        internal static AcsRouterWorkerDeregisteredEventData DeserializeAcsRouterWorkerDeregisteredEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string workerId = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("workerId"u8))
                {
                    workerId = property.Value.GetString();
                    continue;
                }
            }
            return new AcsRouterWorkerDeregisteredEventData(workerId);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AcsRouterWorkerDeregisteredEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcsRouterWorkerDeregisteredEventData(document.RootElement);
        }

        internal partial class AcsRouterWorkerDeregisteredEventDataConverter : JsonConverter<AcsRouterWorkerDeregisteredEventData>
        {
            public override void Write(Utf8JsonWriter writer, AcsRouterWorkerDeregisteredEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override AcsRouterWorkerDeregisteredEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeAcsRouterWorkerDeregisteredEventData(document.RootElement);
            }
        }
    }
}
