// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.Communication.RouterJobWaitingForActivation event. </summary>
    public partial class AcsRouterJobWaitingForActivationEventData : AcsRouterJobEventData
    {
        /// <summary> Initializes a new instance of <see cref="AcsRouterJobWaitingForActivationEventData"/>. </summary>
        /// <param name="unavailableForMatching"> Router Job Waiting For Activation Unavailable For Matching. </param>
        internal AcsRouterJobWaitingForActivationEventData(bool unavailableForMatching)
        {
            ExpiredAttachedWorkerSelectors = new ChangeTrackingList<AcsRouterWorkerSelector>();
            ExpiredRequestedWorkerSelectors = new ChangeTrackingList<AcsRouterWorkerSelector>();
            UnavailableForMatching = unavailableForMatching;
        }

        /// <summary> Initializes a new instance of <see cref="AcsRouterJobWaitingForActivationEventData"/>. </summary>
        /// <param name="jobId"> Router Event Job ID. </param>
        /// <param name="channelReference"> Router Event Channel Reference. </param>
        /// <param name="channelId"> Router Event Channel ID. </param>
        /// <param name="queueId"> Router Job events Queue Id. </param>
        /// <param name="labels"> Router Job events Labels. </param>
        /// <param name="tags"> Router Jobs events Tags. </param>
        /// <param name="priority"> Router Job Waiting For Activation Priority. </param>
        /// <param name="expiredAttachedWorkerSelectors"> Router Job Waiting For Activation Worker Selector Expired. </param>
        /// <param name="expiredRequestedWorkerSelectors"> Router Job Waiting For Activation Requested Worker Selector Expired. </param>
        /// <param name="scheduledOn"> Router Job Waiting For Activation Scheduled Time in UTC. </param>
        /// <param name="unavailableForMatching"> Router Job Waiting For Activation Unavailable For Matching. </param>
        internal AcsRouterJobWaitingForActivationEventData(string jobId, string channelReference, string channelId, string queueId, IReadOnlyDictionary<string, string> labels, IReadOnlyDictionary<string, string> tags, int? priority, IReadOnlyList<AcsRouterWorkerSelector> expiredAttachedWorkerSelectors, IReadOnlyList<AcsRouterWorkerSelector> expiredRequestedWorkerSelectors, DateTimeOffset? scheduledOn, bool unavailableForMatching) : base(jobId, channelReference, channelId, queueId, labels, tags)
        {
            Priority = priority;
            ExpiredAttachedWorkerSelectors = expiredAttachedWorkerSelectors;
            ExpiredRequestedWorkerSelectors = expiredRequestedWorkerSelectors;
            ScheduledOn = scheduledOn;
            UnavailableForMatching = unavailableForMatching;
        }

        /// <summary> Router Job Waiting For Activation Priority. </summary>
        public int? Priority { get; }
        /// <summary> Router Job Waiting For Activation Worker Selector Expired. </summary>
        public IReadOnlyList<AcsRouterWorkerSelector> ExpiredAttachedWorkerSelectors { get; }
        /// <summary> Router Job Waiting For Activation Requested Worker Selector Expired. </summary>
        public IReadOnlyList<AcsRouterWorkerSelector> ExpiredRequestedWorkerSelectors { get; }
        /// <summary> Router Job Waiting For Activation Scheduled Time in UTC. </summary>
        public DateTimeOffset? ScheduledOn { get; }
        /// <summary> Router Job Waiting For Activation Unavailable For Matching. </summary>
        public bool UnavailableForMatching { get; }
    }
}
