// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.Communication.RouterJobReceived event. </summary>
    public partial class AcsRouterJobReceivedEventData : AcsRouterJobEventData
    {
        /// <summary> Initializes a new instance of <see cref="AcsRouterJobReceivedEventData"/>. </summary>
        /// <param name="unavailableForMatching"> Unavailable For Matching for Router Job Received. </param>
        internal AcsRouterJobReceivedEventData(bool unavailableForMatching)
        {
            RequestedWorkerSelectors = new ChangeTrackingList<AcsRouterWorkerSelector>();
            UnavailableForMatching = unavailableForMatching;
        }

        /// <summary> Initializes a new instance of <see cref="AcsRouterJobReceivedEventData"/>. </summary>
        /// <param name="jobId"> Router Event Job ID. </param>
        /// <param name="channelReference"> Router Event Channel Reference. </param>
        /// <param name="channelId"> Router Event Channel ID. </param>
        /// <param name="queueId"> Router Job events Queue Id. </param>
        /// <param name="labels"> Router Job events Labels. </param>
        /// <param name="tags"> Router Jobs events Tags. </param>
        /// <param name="status"> Router Job Received Job Status. </param>
        /// <param name="classificationPolicyId"> Router Job Classification Policy Id. </param>
        /// <param name="priority"> Router Job Priority. </param>
        /// <param name="requestedWorkerSelectors"> Router Job Received Requested Worker Selectors. </param>
        /// <param name="scheduledOn"> Router Job Received Scheduled Time in UTC. </param>
        /// <param name="unavailableForMatching"> Unavailable For Matching for Router Job Received. </param>
        internal AcsRouterJobReceivedEventData(string jobId, string channelReference, string channelId, string queueId, IReadOnlyDictionary<string, string> labels, IReadOnlyDictionary<string, string> tags, AcsRouterJobStatus? status, string classificationPolicyId, int? priority, IReadOnlyList<AcsRouterWorkerSelector> requestedWorkerSelectors, DateTimeOffset? scheduledOn, bool unavailableForMatching) : base(jobId, channelReference, channelId, queueId, labels, tags)
        {
            Status = status;
            ClassificationPolicyId = classificationPolicyId;
            Priority = priority;
            RequestedWorkerSelectors = requestedWorkerSelectors;
            ScheduledOn = scheduledOn;
            UnavailableForMatching = unavailableForMatching;
        }
        /// <summary> Router Job Classification Policy Id. </summary>
        public string ClassificationPolicyId { get; }
        /// <summary> Router Job Priority. </summary>
        public int? Priority { get; }
        /// <summary> Router Job Received Requested Worker Selectors. </summary>
        public IReadOnlyList<AcsRouterWorkerSelector> RequestedWorkerSelectors { get; }
        /// <summary> Router Job Received Scheduled Time in UTC. </summary>
        public DateTimeOffset? ScheduledOn { get; }
        /// <summary> Unavailable For Matching for Router Job Received. </summary>
        public bool UnavailableForMatching { get; }
    }
}
