// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.Communication.RouterJobQueued event. </summary>
    public partial class AcsRouterJobQueuedEventData : AcsRouterJobEventData
    {
        /// <summary> Initializes a new instance of <see cref="AcsRouterJobQueuedEventData"/>. </summary>
        internal AcsRouterJobQueuedEventData()
        {
            AttachedWorkerSelectors = new ChangeTrackingList<AcsRouterWorkerSelector>();
            RequestedWorkerSelectors = new ChangeTrackingList<AcsRouterWorkerSelector>();
        }

        /// <summary> Initializes a new instance of <see cref="AcsRouterJobQueuedEventData"/>. </summary>
        /// <param name="jobId"> Router Event Job ID. </param>
        /// <param name="channelReference"> Router Event Channel Reference. </param>
        /// <param name="channelId"> Router Event Channel ID. </param>
        /// <param name="queueId"> Router Job events Queue Id. </param>
        /// <param name="labels"> Router Job events Labels. </param>
        /// <param name="tags"> Router Jobs events Tags. </param>
        /// <param name="priority"> Router Job Priority. </param>
        /// <param name="attachedWorkerSelectors"> Router Job Queued Attached Worker Selector. </param>
        /// <param name="requestedWorkerSelectors"> Router Job Queued Requested Worker Selector. </param>
        internal AcsRouterJobQueuedEventData(string jobId, string channelReference, string channelId, string queueId, IReadOnlyDictionary<string, string> labels, IReadOnlyDictionary<string, string> tags, int? priority, IReadOnlyList<AcsRouterWorkerSelector> attachedWorkerSelectors, IReadOnlyList<AcsRouterWorkerSelector> requestedWorkerSelectors) : base(jobId, channelReference, channelId, queueId, labels, tags)
        {
            Priority = priority;
            AttachedWorkerSelectors = attachedWorkerSelectors;
            RequestedWorkerSelectors = requestedWorkerSelectors;
        }

        /// <summary> Router Job Priority. </summary>
        public int? Priority { get; }
        /// <summary> Router Job Queued Attached Worker Selector. </summary>
        public IReadOnlyList<AcsRouterWorkerSelector> AttachedWorkerSelectors { get; }
        /// <summary> Router Job Queued Requested Worker Selector. </summary>
        public IReadOnlyList<AcsRouterWorkerSelector> RequestedWorkerSelectors { get; }
    }
}
