// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.Communication.RouterJobCancelled event. </summary>
    public partial class AcsRouterJobCancelledEventData : AcsRouterJobEventData
    {
        /// <summary> Initializes a new instance of <see cref="AcsRouterJobCancelledEventData"/>. </summary>
        internal AcsRouterJobCancelledEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AcsRouterJobCancelledEventData"/>. </summary>
        /// <param name="jobId"> Router Event Job ID. </param>
        /// <param name="channelReference"> Router Event Channel Reference. </param>
        /// <param name="channelId"> Router Event Channel ID. </param>
        /// <param name="queueId"> Router Job events Queue Id. </param>
        /// <param name="labels"> Router Job events Labels. </param>
        /// <param name="tags"> Router Jobs events Tags. </param>
        /// <param name="note"> Router Job Note. </param>
        /// <param name="dispositionCode"> Router Job Disposition Code. </param>
        internal AcsRouterJobCancelledEventData(string jobId, string channelReference, string channelId, string queueId, IReadOnlyDictionary<string, string> labels, IReadOnlyDictionary<string, string> tags, string note, string dispositionCode) : base(jobId, channelReference, channelId, queueId, labels, tags)
        {
            Note = note;
            DispositionCode = dispositionCode;
        }

        /// <summary> Router Job Note. </summary>
        public string Note { get; }
        /// <summary> Router Job Disposition Code. </summary>
        public string DispositionCode { get; }
    }
}
