// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of common properties of all Router events. </summary>
    public partial class AcsRouterEventData
    {
        /// <summary> Initializes a new instance of <see cref="AcsRouterEventData"/>. </summary>
        internal AcsRouterEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AcsRouterEventData"/>. </summary>
        /// <param name="jobId"> Router Event Job ID. </param>
        /// <param name="channelReference"> Router Event Channel Reference. </param>
        /// <param name="channelId"> Router Event Channel ID. </param>
        internal AcsRouterEventData(string jobId, string channelReference, string channelId)
        {
            JobId = jobId;
            ChannelReference = channelReference;
            ChannelId = channelId;
        }

        /// <summary> Router Event Job ID. </summary>
        public string JobId { get; }
        /// <summary> Router Event Channel Reference. </summary>
        public string ChannelReference { get; }
        /// <summary> Router Event Channel ID. </summary>
        public string ChannelId { get; }
    }
}
