// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class AcsRouterChannelConfiguration
    {
        internal static AcsRouterChannelConfiguration DeserializeAcsRouterChannelConfiguration(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string channelId = default;
            int? capacityCostPerJob = default;
            int? maxNumberOfJobs = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("channelId"u8))
                {
                    channelId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("capacityCostPerJob"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    capacityCostPerJob = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("maxNumberOfJobs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxNumberOfJobs = property.Value.GetInt32();
                    continue;
                }
            }
            return new AcsRouterChannelConfiguration(channelId, capacityCostPerJob, maxNumberOfJobs);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AcsRouterChannelConfiguration FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcsRouterChannelConfiguration(document.RootElement);
        }
    }
}
