// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> The recording format type - Mp4, Mp3, Wav. </summary>
    public readonly partial struct AcsRecordingFormatType : IEquatable<AcsRecordingFormatType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AcsRecordingFormatType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AcsRecordingFormatType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WavValue = "Wav";
        private const string Mp3Value = "Mp3";
        private const string Mp4Value = "Mp4";

        /// <summary> Wav. </summary>
        public static AcsRecordingFormatType Wav { get; } = new AcsRecordingFormatType(WavValue);
        /// <summary> Mp3. </summary>
        public static AcsRecordingFormatType Mp3 { get; } = new AcsRecordingFormatType(Mp3Value);
        /// <summary> Mp4. </summary>
        public static AcsRecordingFormatType Mp4 { get; } = new AcsRecordingFormatType(Mp4Value);
        /// <summary> Determines if two <see cref="AcsRecordingFormatType"/> values are the same. </summary>
        public static bool operator ==(AcsRecordingFormatType left, AcsRecordingFormatType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AcsRecordingFormatType"/> values are not the same. </summary>
        public static bool operator !=(AcsRecordingFormatType left, AcsRecordingFormatType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AcsRecordingFormatType"/>. </summary>
        public static implicit operator AcsRecordingFormatType(string value) => new AcsRecordingFormatType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AcsRecordingFormatType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AcsRecordingFormatType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
