// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.Communication.RecordingFileStatusUpdated event. </summary>
    public partial class AcsRecordingFileStatusUpdatedEventData
    {
        /// <summary> Initializes a new instance of <see cref="AcsRecordingFileStatusUpdatedEventData"/>. </summary>
        internal AcsRecordingFileStatusUpdatedEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AcsRecordingFileStatusUpdatedEventData"/>. </summary>
        /// <param name="recordingStorageInfo"> The details of recording storage information. </param>
        /// <param name="recordingStartTime"> The time at which the recording started. </param>
        /// <param name="recordingDurationMs"> The recording duration in milliseconds. </param>
        /// <param name="contentType"> The recording content type- AudioVideo, or Audio. </param>
        /// <param name="channelType"> The recording  channel type - Mixed, Unmixed. </param>
        /// <param name="formatType"> The recording format type - Mp4, Mp3, Wav. </param>
        /// <param name="sessionEndReason"> The reason for ending recording session. </param>
        internal AcsRecordingFileStatusUpdatedEventData(AcsRecordingStorageInfoProperties recordingStorageInfo, DateTimeOffset? recordingStartTime, long? recordingDurationMs, AcsRecordingContentType? contentType, AcsRecordingChannelType? channelType, AcsRecordingFormatType? formatType, string sessionEndReason)
        {
            RecordingStorageInfo = recordingStorageInfo;
            RecordingStartTime = recordingStartTime;
            RecordingDurationMs = recordingDurationMs;
            ContentType = contentType;
            ChannelType = channelType;
            FormatType = formatType;
            SessionEndReason = sessionEndReason;
        }

        /// <summary> The details of recording storage information. </summary>
        public AcsRecordingStorageInfoProperties RecordingStorageInfo { get; }
        /// <summary> The time at which the recording started. </summary>
        public DateTimeOffset? RecordingStartTime { get; }
        /// <summary> The recording duration in milliseconds. </summary>
        public long? RecordingDurationMs { get; }
        /// <summary> The recording content type- AudioVideo, or Audio. </summary>
        public AcsRecordingContentType? ContentType { get; }
        /// <summary> The recording  channel type - Mixed, Unmixed. </summary>
        public AcsRecordingChannelType? ChannelType { get; }
        /// <summary> The recording format type - Mp4, Mp3, Wav. </summary>
        public AcsRecordingFormatType? FormatType { get; }
        /// <summary> The reason for ending recording session. </summary>
        public string SessionEndReason { get; }
    }
}
