// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(AcsRecordingFileStatusUpdatedEventDataConverter))]
    public partial class AcsRecordingFileStatusUpdatedEventData
    {
        internal static AcsRecordingFileStatusUpdatedEventData DeserializeAcsRecordingFileStatusUpdatedEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            AcsRecordingStorageInfoProperties recordingStorageInfo = default;
            DateTimeOffset? recordingStartTime = default;
            long? recordingDurationMs = default;
            AcsRecordingContentType? recordingContentType = default;
            AcsRecordingChannelType? recordingChannelType = default;
            AcsRecordingFormatType? recordingFormatType = default;
            string sessionEndReason = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("recordingStorageInfo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    recordingStorageInfo = AcsRecordingStorageInfoProperties.DeserializeAcsRecordingStorageInfoProperties(property.Value);
                    continue;
                }
                if (property.NameEquals("recordingStartTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    recordingStartTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("recordingDurationMs"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    recordingDurationMs = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("recordingContentType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    recordingContentType = new AcsRecordingContentType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("recordingChannelType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    recordingChannelType = new AcsRecordingChannelType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("recordingFormatType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    recordingFormatType = new AcsRecordingFormatType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("sessionEndReason"u8))
                {
                    sessionEndReason = property.Value.GetString();
                    continue;
                }
            }
            return new AcsRecordingFileStatusUpdatedEventData(
                recordingStorageInfo,
                recordingStartTime,
                recordingDurationMs,
                recordingContentType,
                recordingChannelType,
                recordingFormatType,
                sessionEndReason);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AcsRecordingFileStatusUpdatedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcsRecordingFileStatusUpdatedEventData(document.RootElement);
        }

        internal partial class AcsRecordingFileStatusUpdatedEventDataConverter : JsonConverter<AcsRecordingFileStatusUpdatedEventData>
        {
            public override void Write(Utf8JsonWriter writer, AcsRecordingFileStatusUpdatedEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override AcsRecordingFileStatusUpdatedEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeAcsRecordingFileStatusUpdatedEventData(document.RootElement);
            }
        }
    }
}
