// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> The recording content type- AudioVideo, or Audio. </summary>
    public readonly partial struct AcsRecordingContentType : IEquatable<AcsRecordingContentType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AcsRecordingContentType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AcsRecordingContentType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AudioVideoValue = "AudioVideo";
        private const string AudioValue = "Audio";

        /// <summary> AudioVideo. </summary>
        public static AcsRecordingContentType AudioVideo { get; } = new AcsRecordingContentType(AudioVideoValue);
        /// <summary> Audio. </summary>
        public static AcsRecordingContentType Audio { get; } = new AcsRecordingContentType(AudioValue);
        /// <summary> Determines if two <see cref="AcsRecordingContentType"/> values are the same. </summary>
        public static bool operator ==(AcsRecordingContentType left, AcsRecordingContentType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AcsRecordingContentType"/> values are not the same. </summary>
        public static bool operator !=(AcsRecordingContentType left, AcsRecordingContentType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AcsRecordingContentType"/>. </summary>
        public static implicit operator AcsRecordingContentType(string value) => new AcsRecordingContentType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AcsRecordingContentType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AcsRecordingContentType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
