// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema for all properties of  Recording Chunk Information. </summary>
    public partial class AcsRecordingChunkInfoProperties
    {
        /// <summary> Initializes a new instance of <see cref="AcsRecordingChunkInfoProperties"/>. </summary>
        internal AcsRecordingChunkInfoProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AcsRecordingChunkInfoProperties"/>. </summary>
        /// <param name="documentId"> The documentId of the recording chunk. </param>
        /// <param name="index"> The index of the recording chunk. </param>
        /// <param name="endReason"> The reason for ending the recording chunk. </param>
        /// <param name="metadataLocation"> The location of the metadata for this chunk. </param>
        /// <param name="contentLocation"> The location of the content for this chunk. </param>
        /// <param name="deleteLocation"> The location to delete all chunk storage. </param>
        internal AcsRecordingChunkInfoProperties(string documentId, long? index, string endReason, string metadataLocation, string contentLocation, string deleteLocation)
        {
            DocumentId = documentId;
            Index = index;
            EndReason = endReason;
            MetadataLocation = metadataLocation;
            ContentLocation = contentLocation;
            DeleteLocation = deleteLocation;
        }

        /// <summary> The documentId of the recording chunk. </summary>
        public string DocumentId { get; }
        /// <summary> The index of the recording chunk. </summary>
        public long? Index { get; }
        /// <summary> The reason for ending the recording chunk. </summary>
        public string EndReason { get; }
        /// <summary> The location of the metadata for this chunk. </summary>
        public string MetadataLocation { get; }
        /// <summary> The location of the content for this chunk. </summary>
        public string ContentLocation { get; }
        /// <summary> The location to delete all chunk storage. </summary>
        public string DeleteLocation { get; }
    }
}
