// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class AcsRecordingChunkInfoProperties
    {
        internal static AcsRecordingChunkInfoProperties DeserializeAcsRecordingChunkInfoProperties(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string documentId = default;
            long? index = default;
            string endReason = default;
            string metadataLocation = default;
            string contentLocation = default;
            string deleteLocation = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("documentId"u8))
                {
                    documentId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("index"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    index = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("endReason"u8))
                {
                    endReason = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("metadataLocation"u8))
                {
                    metadataLocation = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("contentLocation"u8))
                {
                    contentLocation = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("deleteLocation"u8))
                {
                    deleteLocation = property.Value.GetString();
                    continue;
                }
            }
            return new AcsRecordingChunkInfoProperties(
                documentId,
                index,
                endReason,
                metadataLocation,
                contentLocation,
                deleteLocation);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AcsRecordingChunkInfoProperties FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcsRecordingChunkInfoProperties(document.RootElement);
        }
    }
}
