// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> The recording  channel type - Mixed, Unmixed. </summary>
    public readonly partial struct AcsRecordingChannelType : IEquatable<AcsRecordingChannelType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AcsRecordingChannelType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AcsRecordingChannelType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MixedValue = "Mixed";
        private const string UnmixedValue = "Unmixed";

        /// <summary> Mixed. </summary>
        public static AcsRecordingChannelType Mixed { get; } = new AcsRecordingChannelType(MixedValue);
        /// <summary> Unmixed. </summary>
        public static AcsRecordingChannelType Unmixed { get; } = new AcsRecordingChannelType(UnmixedValue);
        /// <summary> Determines if two <see cref="AcsRecordingChannelType"/> values are the same. </summary>
        public static bool operator ==(AcsRecordingChannelType left, AcsRecordingChannelType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AcsRecordingChannelType"/> values are not the same. </summary>
        public static bool operator !=(AcsRecordingChannelType left, AcsRecordingChannelType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AcsRecordingChannelType"/>. </summary>
        public static implicit operator AcsRecordingChannelType(string value) => new AcsRecordingChannelType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AcsRecordingChannelType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AcsRecordingChannelType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
