// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.Communication.AdvancedMessageReceived event. </summary>
    public partial class AcsMessageReceivedEventData : AcsMessageEventData
    {
        /// <summary> Initializes a new instance of <see cref="AcsMessageReceivedEventData"/>. </summary>
        internal AcsMessageReceivedEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AcsMessageReceivedEventData"/>. </summary>
        /// <param name="from"> The message sender. </param>
        /// <param name="to"> The message recipient. </param>
        /// <param name="receivedTimestamp"> The time message was received. </param>
        /// <param name="errorInternal"> The channel event error. </param>
        /// <param name="content"> The received message content. </param>
        /// <param name="channelKind"> The received message channel Kind. </param>
        /// <param name="mediaContent"> The received message media content. </param>
        /// <param name="context"> The received message context. </param>
        /// <param name="button"> The received message button content. </param>
        /// <param name="interactiveContent"> The received message interactive content. </param>
        internal AcsMessageReceivedEventData(string @from, string to, DateTimeOffset? receivedTimestamp, AcsMessageChannelEventError errorInternal, string content, AcsMessageChannelKind? channelKind, AcsMessageMediaContent mediaContent, AcsMessageContext context, AcsMessageButtonContent button, AcsMessageInteractiveContent interactiveContent) : base(@from, to, receivedTimestamp, errorInternal)
        {
            Content = content;
            ChannelKind = channelKind;
            MediaContent = mediaContent;
            Context = context;
            Button = button;
            InteractiveContent = interactiveContent;
        }

        /// <summary> The received message content. </summary>
        public string Content { get; }
        /// <summary> The received message channel Kind. </summary>
        public AcsMessageChannelKind? ChannelKind { get; }
        /// <summary> The received message media content. </summary>
        public AcsMessageMediaContent MediaContent { get; }
        /// <summary> The received message context. </summary>
        public AcsMessageContext Context { get; }
        /// <summary> The received message button content. </summary>
        public AcsMessageButtonContent Button { get; }
        /// <summary> The received message interactive content. </summary>
        public AcsMessageInteractiveContent InteractiveContent { get; }
    }
}
