// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(AcsMessageReceivedEventDataConverter))]
    public partial class AcsMessageReceivedEventData
    {
        internal static AcsMessageReceivedEventData DeserializeAcsMessageReceivedEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string content = default;
            AcsMessageChannelKind? channelType = default;
            AcsMessageMediaContent media = default;
            AcsMessageContext context = default;
            AcsMessageButtonContent button = default;
            AcsMessageInteractiveContent interactive = default;
            string @from = default;
            string to = default;
            DateTimeOffset? receivedTimestamp = default;
            AcsMessageChannelEventError error = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("content"u8))
                {
                    content = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("channelType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    channelType = new AcsMessageChannelKind(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("media"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    media = AcsMessageMediaContent.DeserializeAcsMessageMediaContent(property.Value);
                    continue;
                }
                if (property.NameEquals("context"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    context = AcsMessageContext.DeserializeAcsMessageContext(property.Value);
                    continue;
                }
                if (property.NameEquals("button"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    button = AcsMessageButtonContent.DeserializeAcsMessageButtonContent(property.Value);
                    continue;
                }
                if (property.NameEquals("interactive"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    interactive = AcsMessageInteractiveContent.DeserializeAcsMessageInteractiveContent(property.Value);
                    continue;
                }
                if (property.NameEquals("from"u8))
                {
                    @from = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("to"u8))
                {
                    to = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("receivedTimestamp"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    receivedTimestamp = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("error"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    error = AcsMessageChannelEventError.DeserializeAcsMessageChannelEventError(property.Value);
                    continue;
                }
            }
            return new AcsMessageReceivedEventData(
                @from,
                to,
                receivedTimestamp,
                error,
                content,
                channelType,
                media,
                context,
                button,
                interactive);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new AcsMessageReceivedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcsMessageReceivedEventData(document.RootElement);
        }

        internal partial class AcsMessageReceivedEventDataConverter : JsonConverter<AcsMessageReceivedEventData>
        {
            public override void Write(Utf8JsonWriter writer, AcsMessageReceivedEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override AcsMessageReceivedEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeAcsMessageReceivedEventData(document.RootElement);
            }
        }
    }
}
