// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Message Interactive Content. </summary>
    public partial class AcsMessageInteractiveContent
    {
        /// <summary> Initializes a new instance of <see cref="AcsMessageInteractiveContent"/>. </summary>
        internal AcsMessageInteractiveContent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AcsMessageInteractiveContent"/>. </summary>
        /// <param name="replyKind"> The Message interactive reply type. </param>
        /// <param name="buttonReply"> The Message Sent when a customer clicks a button. </param>
        /// <param name="listReply"> The Message Sent when a customer selects an item from a list. </param>
        internal AcsMessageInteractiveContent(AcsInteractiveReplyKind? replyKind, AcsMessageInteractiveButtonReplyContent buttonReply, AcsMessageInteractiveListReplyContent listReply)
        {
            ReplyKind = replyKind;
            ButtonReply = buttonReply;
            ListReply = listReply;
        }

        /// <summary> The Message interactive reply type. </summary>
        public AcsInteractiveReplyKind? ReplyKind { get; }
        /// <summary> The Message Sent when a customer clicks a button. </summary>
        public AcsMessageInteractiveButtonReplyContent ButtonReply { get; }
        /// <summary> The Message Sent when a customer selects an item from a list. </summary>
        public AcsMessageInteractiveListReplyContent ListReply { get; }
    }
}
