// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class AcsMessageInteractiveContent
    {
        internal static AcsMessageInteractiveContent DeserializeAcsMessageInteractiveContent(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            AcsInteractiveReplyKind? type = default;
            AcsMessageInteractiveButtonReplyContent buttonReply = default;
            AcsMessageInteractiveListReplyContent listReply = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("type"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    type = new AcsInteractiveReplyKind(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("buttonReply"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    buttonReply = AcsMessageInteractiveButtonReplyContent.DeserializeAcsMessageInteractiveButtonReplyContent(property.Value);
                    continue;
                }
                if (property.NameEquals("listReply"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    listReply = AcsMessageInteractiveListReplyContent.DeserializeAcsMessageInteractiveListReplyContent(property.Value);
                    continue;
                }
            }
            return new AcsMessageInteractiveContent(type, buttonReply, listReply);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AcsMessageInteractiveContent FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcsMessageInteractiveContent(document.RootElement);
        }
    }
}
