// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(AcsMessageEventDataConverter))]
    public partial class AcsMessageEventData
    {
        internal static AcsMessageEventData DeserializeAcsMessageEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string @from = default;
            string to = default;
            DateTimeOffset? receivedTimestamp = default;
            AcsMessageChannelEventError error = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("from"u8))
                {
                    @from = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("to"u8))
                {
                    to = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("receivedTimestamp"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    receivedTimestamp = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("error"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    error = AcsMessageChannelEventError.DeserializeAcsMessageChannelEventError(property.Value);
                    continue;
                }
            }
            return new AcsMessageEventData(@from, to, receivedTimestamp, error);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AcsMessageEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcsMessageEventData(document.RootElement);
        }

        internal partial class AcsMessageEventDataConverter : JsonConverter<AcsMessageEventData>
        {
            public override void Write(Utf8JsonWriter writer, AcsMessageEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override AcsMessageEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeAcsMessageEventData(document.RootElement);
            }
        }
    }
}
