// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.Communication.AdvancedMessageDeliveryStatusUpdated event. </summary>
    public partial class AcsMessageDeliveryStatusUpdatedEventData : AcsMessageEventData
    {
        /// <summary> Initializes a new instance of <see cref="AcsMessageDeliveryStatusUpdatedEventData"/>. </summary>
        internal AcsMessageDeliveryStatusUpdatedEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AcsMessageDeliveryStatusUpdatedEventData"/>. </summary>
        /// <param name="from"> The message sender. </param>
        /// <param name="to"> The message recipient. </param>
        /// <param name="receivedTimestamp"> The time message was received. </param>
        /// <param name="errorInternal"> The channel event error. </param>
        /// <param name="messageId"> The message id. </param>
        /// <param name="status"> The updated message status. </param>
        /// <param name="channelKind"> The updated message channel type. </param>
        internal AcsMessageDeliveryStatusUpdatedEventData(string @from, string to, DateTimeOffset? receivedTimestamp, AcsMessageChannelEventError errorInternal, string messageId, AcsMessageDeliveryStatus? status, AcsMessageChannelKind? channelKind) : base(@from, to, receivedTimestamp, errorInternal)
        {
            MessageId = messageId;
            Status = status;
            ChannelKind = channelKind;
        }

        /// <summary> The message id. </summary>
        public string MessageId { get; }
        /// <summary> The updated message status. </summary>
        public AcsMessageDeliveryStatus? Status { get; }
        /// <summary> The updated message channel type. </summary>
        public AcsMessageChannelKind? ChannelKind { get; }
    }
}
