// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Text.Json.Serialization;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    [JsonConverter(typeof(AcsMessageDeliveryStatusUpdatedEventDataConverter))]
    public partial class AcsMessageDeliveryStatusUpdatedEventData
    {
        internal static AcsMessageDeliveryStatusUpdatedEventData DeserializeAcsMessageDeliveryStatusUpdatedEventData(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string messageId = default;
            AcsMessageDeliveryStatus? status = default;
            AcsMessageChannelKind? channelType = default;
            string @from = default;
            string to = default;
            DateTimeOffset? receivedTimestamp = default;
            AcsMessageChannelEventError error = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("messageId"u8))
                {
                    messageId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("status"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    status = new AcsMessageDeliveryStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("channelType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    channelType = new AcsMessageChannelKind(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("from"u8))
                {
                    @from = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("to"u8))
                {
                    to = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("receivedTimestamp"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    receivedTimestamp = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("error"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    error = AcsMessageChannelEventError.DeserializeAcsMessageChannelEventError(property.Value);
                    continue;
                }
            }
            return new AcsMessageDeliveryStatusUpdatedEventData(
                @from,
                to,
                receivedTimestamp,
                error,
                messageId,
                status,
                channelType);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new AcsMessageDeliveryStatusUpdatedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcsMessageDeliveryStatusUpdatedEventData(document.RootElement);
        }

        internal partial class AcsMessageDeliveryStatusUpdatedEventDataConverter : JsonConverter<AcsMessageDeliveryStatusUpdatedEventData>
        {
            public override void Write(Utf8JsonWriter writer, AcsMessageDeliveryStatusUpdatedEventData model, JsonSerializerOptions options)
            {
                throw new NotImplementedException();
            }

            public override AcsMessageDeliveryStatusUpdatedEventData Read(ref Utf8JsonReader reader, Type typeToConvert, JsonSerializerOptions options)
            {
                using var document = JsonDocument.ParseValue(ref reader);
                return DeserializeAcsMessageDeliveryStatusUpdatedEventData(document.RootElement);
            }
        }
    }
}
