// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> The Message interactive reply type. </summary>
    public readonly partial struct AcsInteractiveReplyKind : IEquatable<AcsInteractiveReplyKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AcsInteractiveReplyKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AcsInteractiveReplyKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ButtonReplyValue = "buttonReply";
        private const string ListReplyValue = "listReply";
        private const string UnknownValue = "unknown";

        /// <summary> Messaged interactive reply type is ButtonReply. </summary>
        public static AcsInteractiveReplyKind ButtonReply { get; } = new AcsInteractiveReplyKind(ButtonReplyValue);
        /// <summary> Messaged interactive reply type is ListReply. </summary>
        public static AcsInteractiveReplyKind ListReply { get; } = new AcsInteractiveReplyKind(ListReplyValue);
        /// <summary> Messaged interactive reply type is Unknown. </summary>
        public static AcsInteractiveReplyKind Unknown { get; } = new AcsInteractiveReplyKind(UnknownValue);
        /// <summary> Determines if two <see cref="AcsInteractiveReplyKind"/> values are the same. </summary>
        public static bool operator ==(AcsInteractiveReplyKind left, AcsInteractiveReplyKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AcsInteractiveReplyKind"/> values are not the same. </summary>
        public static bool operator !=(AcsInteractiveReplyKind left, AcsInteractiveReplyKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AcsInteractiveReplyKind"/>. </summary>
        public static implicit operator AcsInteractiveReplyKind(string value) => new AcsInteractiveReplyKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AcsInteractiveReplyKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AcsInteractiveReplyKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
