// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class AcsEmailDeliveryReportStatusDetails
    {
        internal static AcsEmailDeliveryReportStatusDetails DeserializeAcsEmailDeliveryReportStatusDetails(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string statusMessage = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("statusMessage"u8))
                {
                    statusMessage = property.Value.GetString();
                    continue;
                }
            }
            return new AcsEmailDeliveryReportStatusDetails(statusMessage);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AcsEmailDeliveryReportStatusDetails FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAcsEmailDeliveryReportStatusDetails(document.RootElement);
        }
    }
}
