// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.Communication.ChatParticipantRemovedFromThreadWithUser event. </summary>
    public partial class AcsChatParticipantRemovedFromThreadWithUserEventData : AcsChatThreadEventBaseProperties
    {
        /// <summary> Initializes a new instance of <see cref="AcsChatParticipantRemovedFromThreadWithUserEventData"/>. </summary>
        internal AcsChatParticipantRemovedFromThreadWithUserEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AcsChatParticipantRemovedFromThreadWithUserEventData"/>. </summary>
        /// <param name="recipientCommunicationIdentifier"> The communication identifier of the target user. </param>
        /// <param name="transactionId"> The transaction id will be used as co-relation vector. </param>
        /// <param name="threadId"> The chat thread id. </param>
        /// <param name="createTime"> The original creation time of the thread. </param>
        /// <param name="version"> The version of the thread. </param>
        /// <param name="time"> The time at which the user was removed to the thread. </param>
        /// <param name="removedByCommunicationIdentifier"> The communication identifier of the user who removed the user. </param>
        /// <param name="participantRemoved"> The details of the user who was removed. </param>
        internal AcsChatParticipantRemovedFromThreadWithUserEventData(CommunicationIdentifierModel recipientCommunicationIdentifier, string transactionId, string threadId, DateTimeOffset? createTime, long? version, DateTimeOffset? time, CommunicationIdentifierModel removedByCommunicationIdentifier, AcsChatThreadParticipantProperties participantRemoved) : base(recipientCommunicationIdentifier, transactionId, threadId, createTime, version)
        {
            Time = time;
            RemovedByCommunicationIdentifier = removedByCommunicationIdentifier;
            ParticipantRemoved = participantRemoved;
        }

        /// <summary> The time at which the user was removed to the thread. </summary>
        public DateTimeOffset? Time { get; }
        /// <summary> The communication identifier of the user who removed the user. </summary>
        public CommunicationIdentifierModel RemovedByCommunicationIdentifier { get; }
        /// <summary> The details of the user who was removed. </summary>
        public AcsChatThreadParticipantProperties ParticipantRemoved { get; }
    }
}
