// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.Communication.ChatThreadParticipantRemoved event. </summary>
    public partial class AcsChatParticipantRemovedFromThreadEventData : AcsChatEventInThreadBaseProperties
    {
        /// <summary> Initializes a new instance of <see cref="AcsChatParticipantRemovedFromThreadEventData"/>. </summary>
        internal AcsChatParticipantRemovedFromThreadEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AcsChatParticipantRemovedFromThreadEventData"/>. </summary>
        /// <param name="transactionId"> The transaction id will be used as co-relation vector. </param>
        /// <param name="threadId"> The chat thread id. </param>
        /// <param name="time"> The time at which the user was removed to the thread. </param>
        /// <param name="removedByCommunicationIdentifier"> The communication identifier of the user who removed the user. </param>
        /// <param name="participantRemoved"> The details of the user who was removed. </param>
        /// <param name="version"> The version of the thread. </param>
        internal AcsChatParticipantRemovedFromThreadEventData(string transactionId, string threadId, DateTimeOffset? time, CommunicationIdentifierModel removedByCommunicationIdentifier, AcsChatThreadParticipantProperties participantRemoved, long? version) : base(transactionId, threadId)
        {
            Time = time;
            RemovedByCommunicationIdentifier = removedByCommunicationIdentifier;
            ParticipantRemoved = participantRemoved;
            Version = version;
        }

        /// <summary> The time at which the user was removed to the thread. </summary>
        public DateTimeOffset? Time { get; }
        /// <summary> The communication identifier of the user who removed the user. </summary>
        public CommunicationIdentifierModel RemovedByCommunicationIdentifier { get; }
        /// <summary> The details of the user who was removed. </summary>
        public AcsChatThreadParticipantProperties ParticipantRemoved { get; }
        /// <summary> The version of the thread. </summary>
        public long? Version { get; }
    }
}
