// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of common properties of all thread-level chat events. </summary>
    public partial class AcsChatEventInThreadBaseProperties
    {
        /// <summary> Initializes a new instance of <see cref="AcsChatEventInThreadBaseProperties"/>. </summary>
        internal AcsChatEventInThreadBaseProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AcsChatEventInThreadBaseProperties"/>. </summary>
        /// <param name="transactionId"> The transaction id will be used as co-relation vector. </param>
        /// <param name="threadId"> The chat thread id. </param>
        internal AcsChatEventInThreadBaseProperties(string transactionId, string threadId)
        {
            TransactionId = transactionId;
            ThreadId = threadId;
        }

        /// <summary> The transaction id will be used as co-relation vector. </summary>
        public string TransactionId { get; }
        /// <summary> The chat thread id. </summary>
        public string ThreadId { get; }
    }
}
