// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of common properties of all chat events. </summary>
    public partial class AcsChatEventBaseProperties
    {
        /// <summary> Initializes a new instance of <see cref="AcsChatEventBaseProperties"/>. </summary>
        internal AcsChatEventBaseProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AcsChatEventBaseProperties"/>. </summary>
        /// <param name="recipientCommunicationIdentifier"> The communication identifier of the target user. </param>
        /// <param name="transactionId"> The transaction id will be used as co-relation vector. </param>
        /// <param name="threadId"> The chat thread id. </param>
        internal AcsChatEventBaseProperties(CommunicationIdentifierModel recipientCommunicationIdentifier, string transactionId, string threadId)
        {
            RecipientCommunicationIdentifier = recipientCommunicationIdentifier;
            TransactionId = transactionId;
            ThreadId = threadId;
        }

        /// <summary> The communication identifier of the target user. </summary>
        public CommunicationIdentifierModel RecipientCommunicationIdentifier { get; }
        /// <summary> The transaction id will be used as co-relation vector. </summary>
        public string TransactionId { get; }
        /// <summary> The chat thread id. </summary>
        public string ThreadId { get; }
    }
}
