// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.Messaging.EventGrid.Models;

namespace Azure.Messaging.EventGrid
{
    internal partial class EventGridRestClient
    {
        private readonly HttpPipeline _pipeline;
        private readonly string _apiVersion;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> Initializes a new instance of EventGridRestClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public EventGridRestClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, string apiVersion = "2018-01-01")
        {
            ClientDiagnostics = clientDiagnostics ?? throw new ArgumentNullException(nameof(clientDiagnostics));
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _apiVersion = apiVersion ?? throw new ArgumentNullException(nameof(apiVersion));
        }

        internal HttpMessage CreatePublishEventGridEventsRequest(string topicHostname, IEnumerable<EventGridEventInternal> events)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw("https://", false);
            uri.AppendRaw(topicHostname, false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteStartArray();
            foreach (var item in events)
            {
                content.JsonWriter.WriteObjectValue(item);
            }
            content.JsonWriter.WriteEndArray();
            request.Content = content;
            return message;
        }

        /// <summary> Publishes a batch of events to an Azure Event Grid topic. </summary>
        /// <param name="topicHostname"> The host name of the topic, e.g. topic1.westus2-1.eventgrid.azure.net. </param>
        /// <param name="events"> An array of events to be published to Event Grid. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="topicHostname"/> or <paramref name="events"/> is null. </exception>
        public async Task<Response> PublishEventGridEventsAsync(string topicHostname, IEnumerable<EventGridEventInternal> events, CancellationToken cancellationToken = default)
        {
            if (topicHostname == null)
            {
                throw new ArgumentNullException(nameof(topicHostname));
            }
            if (events == null)
            {
                throw new ArgumentNullException(nameof(events));
            }

            using var message = CreatePublishEventGridEventsRequest(topicHostname, events);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Publishes a batch of events to an Azure Event Grid topic. </summary>
        /// <param name="topicHostname"> The host name of the topic, e.g. topic1.westus2-1.eventgrid.azure.net. </param>
        /// <param name="events"> An array of events to be published to Event Grid. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="topicHostname"/> or <paramref name="events"/> is null. </exception>
        public Response PublishEventGridEvents(string topicHostname, IEnumerable<EventGridEventInternal> events, CancellationToken cancellationToken = default)
        {
            if (topicHostname == null)
            {
                throw new ArgumentNullException(nameof(topicHostname));
            }
            if (events == null)
            {
                throw new ArgumentNullException(nameof(events));
            }

            using var message = CreatePublishEventGridEventsRequest(topicHostname, events);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreatePublishCloudEventEventsRequest(string topicHostname, IEnumerable<CloudEventInternal> events, string aegChannelName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw("https://", false);
            uri.AppendRaw(topicHostname, false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            if (aegChannelName != null)
            {
                request.Headers.Add("aeg-channel-name", aegChannelName);
            }
            request.Headers.Add("Content-Type", "application/cloudevents-batch+json; charset=utf-8");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteStartArray();
            foreach (var item in events)
            {
                content.JsonWriter.WriteObjectValue(item);
            }
            content.JsonWriter.WriteEndArray();
            request.Content = content;
            return message;
        }

        /// <summary> Publishes a batch of events to an Azure Event Grid topic. </summary>
        /// <param name="topicHostname"> The host name of the topic, e.g. topic1.westus2-1.eventgrid.azure.net. </param>
        /// <param name="events"> An array of events to be published to Event Grid. </param>
        /// <param name="aegChannelName"> Required only when publishing to partner namespaces with partner topic routing mode ChannelNameHeader. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="topicHostname"/> or <paramref name="events"/> is null. </exception>
        public async Task<Response> PublishCloudEventEventsAsync(string topicHostname, IEnumerable<CloudEventInternal> events, string aegChannelName = null, CancellationToken cancellationToken = default)
        {
            if (topicHostname == null)
            {
                throw new ArgumentNullException(nameof(topicHostname));
            }
            if (events == null)
            {
                throw new ArgumentNullException(nameof(events));
            }

            using var message = CreatePublishCloudEventEventsRequest(topicHostname, events, aegChannelName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Publishes a batch of events to an Azure Event Grid topic. </summary>
        /// <param name="topicHostname"> The host name of the topic, e.g. topic1.westus2-1.eventgrid.azure.net. </param>
        /// <param name="events"> An array of events to be published to Event Grid. </param>
        /// <param name="aegChannelName"> Required only when publishing to partner namespaces with partner topic routing mode ChannelNameHeader. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="topicHostname"/> or <paramref name="events"/> is null. </exception>
        public Response PublishCloudEventEvents(string topicHostname, IEnumerable<CloudEventInternal> events, string aegChannelName = null, CancellationToken cancellationToken = default)
        {
            if (topicHostname == null)
            {
                throw new ArgumentNullException(nameof(topicHostname));
            }
            if (events == null)
            {
                throw new ArgumentNullException(nameof(events));
            }

            using var message = CreatePublishCloudEventEventsRequest(topicHostname, events, aegChannelName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreatePublishCustomEventEventsRequest(string topicHostname, IEnumerable<object> events)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw("https://", false);
            uri.AppendRaw(topicHostname, false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteStartArray();
            foreach (var item in events)
            {
                if (item == null)
                {
                    content.JsonWriter.WriteNullValue();
                    continue;
                }
                content.JsonWriter.WriteObjectValue<object>(item);
            }
            content.JsonWriter.WriteEndArray();
            request.Content = content;
            return message;
        }

        /// <summary> Publishes a batch of events to an Azure Event Grid topic. </summary>
        /// <param name="topicHostname"> The host name of the topic, e.g. topic1.westus2-1.eventgrid.azure.net. </param>
        /// <param name="events"> An array of events to be published to Event Grid. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="topicHostname"/> or <paramref name="events"/> is null. </exception>
        public async Task<Response> PublishCustomEventEventsAsync(string topicHostname, IEnumerable<object> events, CancellationToken cancellationToken = default)
        {
            if (topicHostname == null)
            {
                throw new ArgumentNullException(nameof(topicHostname));
            }
            if (events == null)
            {
                throw new ArgumentNullException(nameof(events));
            }

            using var message = CreatePublishCustomEventEventsRequest(topicHostname, events);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Publishes a batch of events to an Azure Event Grid topic. </summary>
        /// <param name="topicHostname"> The host name of the topic, e.g. topic1.westus2-1.eventgrid.azure.net. </param>
        /// <param name="events"> An array of events to be published to Event Grid. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="topicHostname"/> or <paramref name="events"/> is null. </exception>
        public Response PublishCustomEventEvents(string topicHostname, IEnumerable<object> events, CancellationToken cancellationToken = default)
        {
            if (topicHostname == null)
            {
                throw new ArgumentNullException(nameof(topicHostname));
            }
            if (events == null)
            {
                throw new ArgumentNullException(nameof(events));
            }

            using var message = CreatePublishCustomEventEventsRequest(topicHostname, events);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
