﻿// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Messaging.EventGrid.Models
{
    /// <summary> The recording format type - Mp4, Mp3, Wav. </summary>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public readonly partial struct RecordingFormatType : IEquatable<RecordingFormatType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RecordingFormatType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RecordingFormatType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WavValue = "Wav";
        private const string Mp3Value = "Mp3";
        private const string Mp4Value = "Mp4";

        /// <summary> Wav. </summary>
        public static RecordingFormatType Wav { get; } = new RecordingFormatType(WavValue);
        /// <summary> Mp3. </summary>
        public static RecordingFormatType Mp3 { get; } = new RecordingFormatType(Mp3Value);
        /// <summary> Mp4. </summary>
        public static RecordingFormatType Mp4 { get; } = new RecordingFormatType(Mp4Value);
        /// <summary> Determines if two <see cref="RecordingFormatType"/> values are the same. </summary>
        public static bool operator ==(RecordingFormatType left, RecordingFormatType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RecordingFormatType"/> values are not the same. </summary>
        public static bool operator !=(RecordingFormatType left, RecordingFormatType right) => !left.Equals(right);
        /// <summary> Converts a string to a <see cref="RecordingFormatType"/>. </summary>
        public static implicit operator RecordingFormatType(string value) => new RecordingFormatType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RecordingFormatType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RecordingFormatType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value?.GetHashCode() ?? 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
