// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> The status for a storage task. </summary>
    public readonly partial struct StorageTaskCompletedStatus : IEquatable<StorageTaskCompletedStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StorageTaskCompletedStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StorageTaskCompletedStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";

        /// <summary> Succeeded. </summary>
        public static StorageTaskCompletedStatus Succeeded { get; } = new StorageTaskCompletedStatus(SucceededValue);
        /// <summary> Failed. </summary>
        public static StorageTaskCompletedStatus Failed { get; } = new StorageTaskCompletedStatus(FailedValue);
        /// <summary> Determines if two <see cref="StorageTaskCompletedStatus"/> values are the same. </summary>
        public static bool operator ==(StorageTaskCompletedStatus left, StorageTaskCompletedStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StorageTaskCompletedStatus"/> values are not the same. </summary>
        public static bool operator !=(StorageTaskCompletedStatus left, StorageTaskCompletedStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StorageTaskCompletedStatus"/>. </summary>
        public static implicit operator StorageTaskCompletedStatus(string value) => new StorageTaskCompletedStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StorageTaskCompletedStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StorageTaskCompletedStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
