// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class StorageLifecyclePolicyActionSummaryDetail : IUtf8JsonSerializable, IJsonModel<StorageLifecyclePolicyActionSummaryDetail>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<StorageLifecyclePolicyActionSummaryDetail>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<StorageLifecyclePolicyActionSummaryDetail>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageLifecyclePolicyActionSummaryDetail>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageLifecyclePolicyActionSummaryDetail)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(TotalObjectsCount))
            {
                writer.WritePropertyName("totalObjectsCount"u8);
                writer.WriteNumberValue(TotalObjectsCount.Value);
            }
            if (Optional.IsDefined(SuccessCount))
            {
                writer.WritePropertyName("successCount"u8);
                writer.WriteNumberValue(SuccessCount.Value);
            }
            if (Optional.IsDefined(ErrorList))
            {
                writer.WritePropertyName("errorList"u8);
                writer.WriteStringValue(ErrorList);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        StorageLifecyclePolicyActionSummaryDetail IJsonModel<StorageLifecyclePolicyActionSummaryDetail>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageLifecyclePolicyActionSummaryDetail>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(StorageLifecyclePolicyActionSummaryDetail)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeStorageLifecyclePolicyActionSummaryDetail(document.RootElement, options);
        }

        internal static StorageLifecyclePolicyActionSummaryDetail DeserializeStorageLifecyclePolicyActionSummaryDetail(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            long? totalObjectsCount = default;
            long? successCount = default;
            string errorList = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("totalObjectsCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalObjectsCount = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("successCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    successCount = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("errorList"u8))
                {
                    errorList = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new StorageLifecyclePolicyActionSummaryDetail(totalObjectsCount, successCount, errorList, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<StorageLifecyclePolicyActionSummaryDetail>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageLifecyclePolicyActionSummaryDetail>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(StorageLifecyclePolicyActionSummaryDetail)} does not support writing '{options.Format}' format.");
            }
        }

        StorageLifecyclePolicyActionSummaryDetail IPersistableModel<StorageLifecyclePolicyActionSummaryDetail>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<StorageLifecyclePolicyActionSummaryDetail>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeStorageLifecyclePolicyActionSummaryDetail(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(StorageLifecyclePolicyActionSummaryDetail)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<StorageLifecyclePolicyActionSummaryDetail>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static StorageLifecyclePolicyActionSummaryDetail FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeStorageLifecyclePolicyActionSummaryDetail(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
