// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary>
    /// Describes the schema of the common properties across all ARN system topic
    /// delete events
    /// </summary>
    public partial class ResourceNotificationsResourceDeletedEventData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceNotificationsResourceDeletedEventData"/>. </summary>
        /// <param name="resourceDetails"> resourceInfo details for delete event. </param>
        /// <param name="operationalDetails"> details about operational info. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceDetails"/> or <paramref name="operationalDetails"/> is null. </exception>
        internal ResourceNotificationsResourceDeletedEventData(ResourceNotificationsResourceDeletedDetails resourceDetails, ResourceNotificationsOperationalDetails operationalDetails)
        {
            Argument.AssertNotNull(resourceDetails, nameof(resourceDetails));
            Argument.AssertNotNull(operationalDetails, nameof(operationalDetails));

            ResourceDetails = resourceDetails;
            OperationalDetails = operationalDetails;
        }

        /// <summary> Initializes a new instance of <see cref="ResourceNotificationsResourceDeletedEventData"/>. </summary>
        /// <param name="resourceDetails"> resourceInfo details for delete event. </param>
        /// <param name="operationalDetails"> details about operational info. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceNotificationsResourceDeletedEventData(ResourceNotificationsResourceDeletedDetails resourceDetails, ResourceNotificationsOperationalDetails operationalDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ResourceDetails = resourceDetails;
            OperationalDetails = operationalDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ResourceNotificationsResourceDeletedEventData"/> for deserialization. </summary>
        internal ResourceNotificationsResourceDeletedEventData()
        {
        }

        /// <summary> resourceInfo details for delete event. </summary>
        public ResourceNotificationsResourceDeletedDetails ResourceDetails { get; }
        /// <summary> details about operational info. </summary>
        public ResourceNotificationsOperationalDetails OperationalDetails { get; }
    }
}
