// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> details of operational info. </summary>
    public partial class ResourceNotificationsOperationalDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ResourceNotificationsOperationalDetails"/>. </summary>
        /// <param name="resourceEventTime"> Date and Time when resource was updated. </param>
        internal ResourceNotificationsOperationalDetails(DateTimeOffset resourceEventTime)
        {
            ResourceEventTime = resourceEventTime;
        }

        /// <summary> Initializes a new instance of <see cref="ResourceNotificationsOperationalDetails"/>. </summary>
        /// <param name="resourceEventTime"> Date and Time when resource was updated. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceNotificationsOperationalDetails(DateTimeOffset resourceEventTime, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ResourceEventTime = resourceEventTime;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ResourceNotificationsOperationalDetails"/> for deserialization. </summary>
        internal ResourceNotificationsOperationalDetails()
        {
        }

        /// <summary> Date and Time when resource was updated. </summary>
        public DateTimeOffset ResourceEventTime { get; }
    }
}
