// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary>
    /// Schema of the Data property of an EventGridEvent for a
    /// Microsoft.ResourceNotifications.HealthResources.AvailabilityStatusChanged
    /// event.
    /// </summary>
    public partial class ResourceNotificationsHealthResourcesAvailabilityStatusChangedEventData : ResourceNotificationsResourceUpdatedEventData
    {
        /// <summary> Initializes a new instance of <see cref="ResourceNotificationsHealthResourcesAvailabilityStatusChangedEventData"/>. </summary>
        /// <param name="resourceDetails"> resourceInfo details for update event. </param>
        /// <param name="operationalDetails"> details about operational info. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceDetails"/> or <paramref name="operationalDetails"/> is null. </exception>
        internal ResourceNotificationsHealthResourcesAvailabilityStatusChangedEventData(ResourceNotificationsResourceUpdatedDetails resourceDetails, ResourceNotificationsOperationalDetails operationalDetails) : base(resourceDetails, operationalDetails)
        {
            Argument.AssertNotNull(resourceDetails, nameof(resourceDetails));
            Argument.AssertNotNull(operationalDetails, nameof(operationalDetails));
        }

        /// <summary> Initializes a new instance of <see cref="ResourceNotificationsHealthResourcesAvailabilityStatusChangedEventData"/>. </summary>
        /// <param name="resourceDetails"> resourceInfo details for update event. </param>
        /// <param name="operationalDetails"> details about operational info. </param>
        /// <param name="apiVersion"> api version of the resource properties bag. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ResourceNotificationsHealthResourcesAvailabilityStatusChangedEventData(ResourceNotificationsResourceUpdatedDetails resourceDetails, ResourceNotificationsOperationalDetails operationalDetails, string apiVersion, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(resourceDetails, operationalDetails, apiVersion, serializedAdditionalRawData)
        {
        }

        /// <summary> Initializes a new instance of <see cref="ResourceNotificationsHealthResourcesAvailabilityStatusChangedEventData"/> for deserialization. </summary>
        internal ResourceNotificationsHealthResourcesAvailabilityStatusChangedEventData()
        {
        }
    }
}
