// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class MediaLiveEventTrackDiscontinuityDetectedEventData : IUtf8JsonSerializable, IJsonModel<MediaLiveEventTrackDiscontinuityDetectedEventData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MediaLiveEventTrackDiscontinuityDetectedEventData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MediaLiveEventTrackDiscontinuityDetectedEventData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MediaLiveEventTrackDiscontinuityDetectedEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MediaLiveEventTrackDiscontinuityDetectedEventData)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(TrackType))
            {
                writer.WritePropertyName("trackType"u8);
                writer.WriteStringValue(TrackType);
            }
            if (Optional.IsDefined(TrackName))
            {
                writer.WritePropertyName("trackName"u8);
                writer.WriteStringValue(TrackName);
            }
            if (Optional.IsDefined(Bitrate))
            {
                writer.WritePropertyName("bitrate"u8);
                writer.WriteNumberValue(Bitrate.Value);
            }
            if (Optional.IsDefined(PreviousTimestamp))
            {
                writer.WritePropertyName("previousTimestamp"u8);
                writer.WriteStringValue(PreviousTimestamp);
            }
            if (Optional.IsDefined(NewTimestamp))
            {
                writer.WritePropertyName("newTimestamp"u8);
                writer.WriteStringValue(NewTimestamp);
            }
            if (Optional.IsDefined(Timescale))
            {
                writer.WritePropertyName("timescale"u8);
                writer.WriteStringValue(Timescale);
            }
            if (Optional.IsDefined(DiscontinuityGap))
            {
                writer.WritePropertyName("discontinuityGap"u8);
                writer.WriteStringValue(DiscontinuityGap);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MediaLiveEventTrackDiscontinuityDetectedEventData IJsonModel<MediaLiveEventTrackDiscontinuityDetectedEventData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MediaLiveEventTrackDiscontinuityDetectedEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MediaLiveEventTrackDiscontinuityDetectedEventData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMediaLiveEventTrackDiscontinuityDetectedEventData(document.RootElement, options);
        }

        internal static MediaLiveEventTrackDiscontinuityDetectedEventData DeserializeMediaLiveEventTrackDiscontinuityDetectedEventData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string trackType = default;
            string trackName = default;
            long? bitrate = default;
            string previousTimestamp = default;
            string newTimestamp = default;
            string timescale = default;
            string discontinuityGap = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("trackType"u8))
                {
                    trackType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("trackName"u8))
                {
                    trackName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("bitrate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    bitrate = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("previousTimestamp"u8))
                {
                    previousTimestamp = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("newTimestamp"u8))
                {
                    newTimestamp = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("timescale"u8))
                {
                    timescale = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("discontinuityGap"u8))
                {
                    discontinuityGap = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MediaLiveEventTrackDiscontinuityDetectedEventData(
                trackType,
                trackName,
                bitrate,
                previousTimestamp,
                newTimestamp,
                timescale,
                discontinuityGap,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<MediaLiveEventTrackDiscontinuityDetectedEventData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MediaLiveEventTrackDiscontinuityDetectedEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(MediaLiveEventTrackDiscontinuityDetectedEventData)} does not support writing '{options.Format}' format.");
            }
        }

        MediaLiveEventTrackDiscontinuityDetectedEventData IPersistableModel<MediaLiveEventTrackDiscontinuityDetectedEventData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MediaLiveEventTrackDiscontinuityDetectedEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMediaLiveEventTrackDiscontinuityDetectedEventData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MediaLiveEventTrackDiscontinuityDetectedEventData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MediaLiveEventTrackDiscontinuityDetectedEventData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static MediaLiveEventTrackDiscontinuityDetectedEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeMediaLiveEventTrackDiscontinuityDetectedEventData(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
