// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class MediaLiveEventIngestHeartbeatEventData : IUtf8JsonSerializable, IJsonModel<MediaLiveEventIngestHeartbeatEventData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MediaLiveEventIngestHeartbeatEventData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MediaLiveEventIngestHeartbeatEventData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MediaLiveEventIngestHeartbeatEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MediaLiveEventIngestHeartbeatEventData)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(TrackType))
            {
                writer.WritePropertyName("trackType"u8);
                writer.WriteStringValue(TrackType);
            }
            if (Optional.IsDefined(TrackName))
            {
                writer.WritePropertyName("trackName"u8);
                writer.WriteStringValue(TrackName);
            }
            if (Optional.IsDefined(TranscriptionLanguage))
            {
                writer.WritePropertyName("transcriptionLanguage"u8);
                writer.WriteStringValue(TranscriptionLanguage);
            }
            if (Optional.IsDefined(TranscriptionState))
            {
                writer.WritePropertyName("transcriptionState"u8);
                writer.WriteStringValue(TranscriptionState);
            }
            if (Optional.IsDefined(Bitrate))
            {
                writer.WritePropertyName("bitrate"u8);
                writer.WriteNumberValue(Bitrate.Value);
            }
            if (Optional.IsDefined(IncomingBitrate))
            {
                writer.WritePropertyName("incomingBitrate"u8);
                writer.WriteNumberValue(IncomingBitrate.Value);
            }
            if (Optional.IsDefined(IngestDriftValue))
            {
                writer.WritePropertyName("ingestDriftValue"u8);
                writer.WriteStringValue(IngestDriftValue);
            }
            if (Optional.IsDefined(LastFragmentArrivalTime))
            {
                writer.WritePropertyName("lastFragmentArrivalTime"u8);
                writer.WriteStringValue(LastFragmentArrivalTime);
            }
            if (Optional.IsDefined(LastTimestamp))
            {
                writer.WritePropertyName("lastTimestamp"u8);
                writer.WriteStringValue(LastTimestamp);
            }
            if (Optional.IsDefined(Timescale))
            {
                writer.WritePropertyName("timescale"u8);
                writer.WriteStringValue(Timescale);
            }
            if (Optional.IsDefined(OverlapCount))
            {
                writer.WritePropertyName("overlapCount"u8);
                writer.WriteNumberValue(OverlapCount.Value);
            }
            if (Optional.IsDefined(DiscontinuityCount))
            {
                writer.WritePropertyName("discontinuityCount"u8);
                writer.WriteNumberValue(DiscontinuityCount.Value);
            }
            if (Optional.IsDefined(NonincreasingCount))
            {
                writer.WritePropertyName("nonincreasingCount"u8);
                writer.WriteNumberValue(NonincreasingCount.Value);
            }
            if (Optional.IsDefined(UnexpectedBitrate))
            {
                writer.WritePropertyName("unexpectedBitrate"u8);
                writer.WriteBooleanValue(UnexpectedBitrate.Value);
            }
            if (Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State);
            }
            if (Optional.IsDefined(Healthy))
            {
                writer.WritePropertyName("healthy"u8);
                writer.WriteBooleanValue(Healthy.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MediaLiveEventIngestHeartbeatEventData IJsonModel<MediaLiveEventIngestHeartbeatEventData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MediaLiveEventIngestHeartbeatEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MediaLiveEventIngestHeartbeatEventData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMediaLiveEventIngestHeartbeatEventData(document.RootElement, options);
        }

        internal static MediaLiveEventIngestHeartbeatEventData DeserializeMediaLiveEventIngestHeartbeatEventData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string trackType = default;
            string trackName = default;
            string transcriptionLanguage = default;
            string transcriptionState = default;
            long? bitrate = default;
            long? incomingBitrate = default;
            string ingestDriftValue = default;
            string lastFragmentArrivalTime = default;
            string lastTimestamp = default;
            string timescale = default;
            long? overlapCount = default;
            long? discontinuityCount = default;
            long? nonincreasingCount = default;
            bool? unexpectedBitrate = default;
            string state = default;
            bool? healthy = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("trackType"u8))
                {
                    trackType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("trackName"u8))
                {
                    trackName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("transcriptionLanguage"u8))
                {
                    transcriptionLanguage = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("transcriptionState"u8))
                {
                    transcriptionState = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("bitrate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    bitrate = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("incomingBitrate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    incomingBitrate = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("ingestDriftValue"u8))
                {
                    ingestDriftValue = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lastFragmentArrivalTime"u8))
                {
                    lastFragmentArrivalTime = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lastTimestamp"u8))
                {
                    lastTimestamp = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("timescale"u8))
                {
                    timescale = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("overlapCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    overlapCount = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("discontinuityCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    discontinuityCount = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("nonincreasingCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    nonincreasingCount = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("unexpectedBitrate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    unexpectedBitrate = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("state"u8))
                {
                    state = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("healthy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    healthy = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MediaLiveEventIngestHeartbeatEventData(
                trackType,
                trackName,
                transcriptionLanguage,
                transcriptionState,
                bitrate,
                incomingBitrate,
                ingestDriftValue,
                lastFragmentArrivalTime,
                lastTimestamp,
                timescale,
                overlapCount,
                discontinuityCount,
                nonincreasingCount,
                unexpectedBitrate,
                state,
                healthy,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<MediaLiveEventIngestHeartbeatEventData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MediaLiveEventIngestHeartbeatEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(MediaLiveEventIngestHeartbeatEventData)} does not support writing '{options.Format}' format.");
            }
        }

        MediaLiveEventIngestHeartbeatEventData IPersistableModel<MediaLiveEventIngestHeartbeatEventData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MediaLiveEventIngestHeartbeatEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMediaLiveEventIngestHeartbeatEventData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MediaLiveEventIngestHeartbeatEventData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MediaLiveEventIngestHeartbeatEventData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static MediaLiveEventIngestHeartbeatEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeMediaLiveEventIngestHeartbeatEventData(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
