// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Incoming video stream out of sync event data. Schema of the data property of an EventGridEvent for a Microsoft.Media.LiveEventIncomingVideoStreamsOutOfSync event. </summary>
    public partial class MediaLiveEventIncomingVideoStreamsOutOfSyncEventData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MediaLiveEventIncomingVideoStreamsOutOfSyncEventData"/>. </summary>
        internal MediaLiveEventIncomingVideoStreamsOutOfSyncEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MediaLiveEventIncomingVideoStreamsOutOfSyncEventData"/>. </summary>
        /// <param name="firstTimestamp"> Gets the first timestamp received for one of the quality levels. </param>
        /// <param name="firstDuration"> Gets the duration of the data chunk with first timestamp. </param>
        /// <param name="secondTimestamp"> Gets the timestamp received for some other quality levels. </param>
        /// <param name="secondDuration"> Gets the duration of the data chunk with second timestamp. </param>
        /// <param name="timescale"> Gets the timescale in which both the timestamps and durations are represented. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MediaLiveEventIncomingVideoStreamsOutOfSyncEventData(string firstTimestamp, string firstDuration, string secondTimestamp, string secondDuration, string timescale, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FirstTimestamp = firstTimestamp;
            FirstDuration = firstDuration;
            SecondTimestamp = secondTimestamp;
            SecondDuration = secondDuration;
            Timescale = timescale;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the first timestamp received for one of the quality levels. </summary>
        public string FirstTimestamp { get; }
        /// <summary> Gets the duration of the data chunk with first timestamp. </summary>
        public string FirstDuration { get; }
        /// <summary> Gets the timestamp received for some other quality levels. </summary>
        public string SecondTimestamp { get; }
        /// <summary> Gets the duration of the data chunk with second timestamp. </summary>
        public string SecondDuration { get; }
        /// <summary> Gets the timescale in which both the timestamps and durations are represented. </summary>
        public string Timescale { get; }
    }
}
