// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class MediaLiveEventIncomingVideoStreamsOutOfSyncEventData : IUtf8JsonSerializable, IJsonModel<MediaLiveEventIncomingVideoStreamsOutOfSyncEventData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MediaLiveEventIncomingVideoStreamsOutOfSyncEventData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MediaLiveEventIncomingVideoStreamsOutOfSyncEventData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MediaLiveEventIncomingVideoStreamsOutOfSyncEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MediaLiveEventIncomingVideoStreamsOutOfSyncEventData)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(FirstTimestamp))
            {
                writer.WritePropertyName("firstTimestamp"u8);
                writer.WriteStringValue(FirstTimestamp);
            }
            if (Optional.IsDefined(FirstDuration))
            {
                writer.WritePropertyName("firstDuration"u8);
                writer.WriteStringValue(FirstDuration);
            }
            if (Optional.IsDefined(SecondTimestamp))
            {
                writer.WritePropertyName("secondTimestamp"u8);
                writer.WriteStringValue(SecondTimestamp);
            }
            if (Optional.IsDefined(SecondDuration))
            {
                writer.WritePropertyName("secondDuration"u8);
                writer.WriteStringValue(SecondDuration);
            }
            if (Optional.IsDefined(Timescale))
            {
                writer.WritePropertyName("timescale"u8);
                writer.WriteStringValue(Timescale);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MediaLiveEventIncomingVideoStreamsOutOfSyncEventData IJsonModel<MediaLiveEventIncomingVideoStreamsOutOfSyncEventData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MediaLiveEventIncomingVideoStreamsOutOfSyncEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MediaLiveEventIncomingVideoStreamsOutOfSyncEventData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMediaLiveEventIncomingVideoStreamsOutOfSyncEventData(document.RootElement, options);
        }

        internal static MediaLiveEventIncomingVideoStreamsOutOfSyncEventData DeserializeMediaLiveEventIncomingVideoStreamsOutOfSyncEventData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string firstTimestamp = default;
            string firstDuration = default;
            string secondTimestamp = default;
            string secondDuration = default;
            string timescale = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("firstTimestamp"u8))
                {
                    firstTimestamp = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("firstDuration"u8))
                {
                    firstDuration = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("secondTimestamp"u8))
                {
                    secondTimestamp = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("secondDuration"u8))
                {
                    secondDuration = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("timescale"u8))
                {
                    timescale = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MediaLiveEventIncomingVideoStreamsOutOfSyncEventData(
                firstTimestamp,
                firstDuration,
                secondTimestamp,
                secondDuration,
                timescale,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<MediaLiveEventIncomingVideoStreamsOutOfSyncEventData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MediaLiveEventIncomingVideoStreamsOutOfSyncEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(MediaLiveEventIncomingVideoStreamsOutOfSyncEventData)} does not support writing '{options.Format}' format.");
            }
        }

        MediaLiveEventIncomingVideoStreamsOutOfSyncEventData IPersistableModel<MediaLiveEventIncomingVideoStreamsOutOfSyncEventData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MediaLiveEventIncomingVideoStreamsOutOfSyncEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMediaLiveEventIncomingVideoStreamsOutOfSyncEventData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MediaLiveEventIncomingVideoStreamsOutOfSyncEventData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MediaLiveEventIncomingVideoStreamsOutOfSyncEventData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static MediaLiveEventIncomingVideoStreamsOutOfSyncEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeMediaLiveEventIncomingVideoStreamsOutOfSyncEventData(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
