// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Incoming streams out of sync event data. Schema of the data property of an EventGridEvent for a Microsoft.Media.LiveEventIncomingStreamsOutOfSync event. </summary>
    public partial class MediaLiveEventIncomingStreamsOutOfSyncEventData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MediaLiveEventIncomingStreamsOutOfSyncEventData"/>. </summary>
        internal MediaLiveEventIncomingStreamsOutOfSyncEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MediaLiveEventIncomingStreamsOutOfSyncEventData"/>. </summary>
        /// <param name="minLastTimestamp"> Gets the minimum last timestamp received. </param>
        /// <param name="typeOfStreamWithMinLastTimestamp"> Gets the type of stream with minimum last timestamp. </param>
        /// <param name="maxLastTimestamp"> Gets the maximum timestamp among all the tracks (audio or video). </param>
        /// <param name="typeOfStreamWithMaxLastTimestamp"> Gets the type of stream with maximum last timestamp. </param>
        /// <param name="timescaleOfMinLastTimestamp"> Gets the timescale in which \"MinLastTimestamp\" is represented. </param>
        /// <param name="timescaleOfMaxLastTimestamp"> Gets the timescale in which \"MaxLastTimestamp\" is represented. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MediaLiveEventIncomingStreamsOutOfSyncEventData(string minLastTimestamp, string typeOfStreamWithMinLastTimestamp, string maxLastTimestamp, string typeOfStreamWithMaxLastTimestamp, string timescaleOfMinLastTimestamp, string timescaleOfMaxLastTimestamp, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MinLastTimestamp = minLastTimestamp;
            TypeOfStreamWithMinLastTimestamp = typeOfStreamWithMinLastTimestamp;
            MaxLastTimestamp = maxLastTimestamp;
            TypeOfStreamWithMaxLastTimestamp = typeOfStreamWithMaxLastTimestamp;
            TimescaleOfMinLastTimestamp = timescaleOfMinLastTimestamp;
            TimescaleOfMaxLastTimestamp = timescaleOfMaxLastTimestamp;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the minimum last timestamp received. </summary>
        public string MinLastTimestamp { get; }
        /// <summary> Gets the type of stream with minimum last timestamp. </summary>
        public string TypeOfStreamWithMinLastTimestamp { get; }
        /// <summary> Gets the maximum timestamp among all the tracks (audio or video). </summary>
        public string MaxLastTimestamp { get; }
        /// <summary> Gets the type of stream with maximum last timestamp. </summary>
        public string TypeOfStreamWithMaxLastTimestamp { get; }
        /// <summary> Gets the timescale in which \"MinLastTimestamp\" is represented. </summary>
        public string TimescaleOfMinLastTimestamp { get; }
        /// <summary> Gets the timescale in which \"MaxLastTimestamp\" is represented. </summary>
        public string TimescaleOfMaxLastTimestamp { get; }
    }
}
