// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class MediaLiveEventIncomingStreamsOutOfSyncEventData : IUtf8JsonSerializable, IJsonModel<MediaLiveEventIncomingStreamsOutOfSyncEventData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MediaLiveEventIncomingStreamsOutOfSyncEventData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MediaLiveEventIncomingStreamsOutOfSyncEventData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MediaLiveEventIncomingStreamsOutOfSyncEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MediaLiveEventIncomingStreamsOutOfSyncEventData)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(MinLastTimestamp))
            {
                writer.WritePropertyName("minLastTimestamp"u8);
                writer.WriteStringValue(MinLastTimestamp);
            }
            if (Optional.IsDefined(TypeOfStreamWithMinLastTimestamp))
            {
                writer.WritePropertyName("typeOfStreamWithMinLastTimestamp"u8);
                writer.WriteStringValue(TypeOfStreamWithMinLastTimestamp);
            }
            if (Optional.IsDefined(MaxLastTimestamp))
            {
                writer.WritePropertyName("maxLastTimestamp"u8);
                writer.WriteStringValue(MaxLastTimestamp);
            }
            if (Optional.IsDefined(TypeOfStreamWithMaxLastTimestamp))
            {
                writer.WritePropertyName("typeOfStreamWithMaxLastTimestamp"u8);
                writer.WriteStringValue(TypeOfStreamWithMaxLastTimestamp);
            }
            if (Optional.IsDefined(TimescaleOfMinLastTimestamp))
            {
                writer.WritePropertyName("timescaleOfMinLastTimestamp"u8);
                writer.WriteStringValue(TimescaleOfMinLastTimestamp);
            }
            if (Optional.IsDefined(TimescaleOfMaxLastTimestamp))
            {
                writer.WritePropertyName("timescaleOfMaxLastTimestamp"u8);
                writer.WriteStringValue(TimescaleOfMaxLastTimestamp);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MediaLiveEventIncomingStreamsOutOfSyncEventData IJsonModel<MediaLiveEventIncomingStreamsOutOfSyncEventData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MediaLiveEventIncomingStreamsOutOfSyncEventData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MediaLiveEventIncomingStreamsOutOfSyncEventData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMediaLiveEventIncomingStreamsOutOfSyncEventData(document.RootElement, options);
        }

        internal static MediaLiveEventIncomingStreamsOutOfSyncEventData DeserializeMediaLiveEventIncomingStreamsOutOfSyncEventData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string minLastTimestamp = default;
            string typeOfStreamWithMinLastTimestamp = default;
            string maxLastTimestamp = default;
            string typeOfStreamWithMaxLastTimestamp = default;
            string timescaleOfMinLastTimestamp = default;
            string timescaleOfMaxLastTimestamp = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("minLastTimestamp"u8))
                {
                    minLastTimestamp = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("typeOfStreamWithMinLastTimestamp"u8))
                {
                    typeOfStreamWithMinLastTimestamp = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("maxLastTimestamp"u8))
                {
                    maxLastTimestamp = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("typeOfStreamWithMaxLastTimestamp"u8))
                {
                    typeOfStreamWithMaxLastTimestamp = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("timescaleOfMinLastTimestamp"u8))
                {
                    timescaleOfMinLastTimestamp = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("timescaleOfMaxLastTimestamp"u8))
                {
                    timescaleOfMaxLastTimestamp = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MediaLiveEventIncomingStreamsOutOfSyncEventData(
                minLastTimestamp,
                typeOfStreamWithMinLastTimestamp,
                maxLastTimestamp,
                typeOfStreamWithMaxLastTimestamp,
                timescaleOfMinLastTimestamp,
                timescaleOfMaxLastTimestamp,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<MediaLiveEventIncomingStreamsOutOfSyncEventData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MediaLiveEventIncomingStreamsOutOfSyncEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(MediaLiveEventIncomingStreamsOutOfSyncEventData)} does not support writing '{options.Format}' format.");
            }
        }

        MediaLiveEventIncomingStreamsOutOfSyncEventData IPersistableModel<MediaLiveEventIncomingStreamsOutOfSyncEventData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MediaLiveEventIncomingStreamsOutOfSyncEventData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMediaLiveEventIncomingStreamsOutOfSyncEventData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MediaLiveEventIncomingStreamsOutOfSyncEventData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MediaLiveEventIncomingStreamsOutOfSyncEventData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static MediaLiveEventIncomingStreamsOutOfSyncEventData FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeMediaLiveEventIncomingStreamsOutOfSyncEventData(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
