// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Ingest fragment dropped event data. Schema of the data property of an EventGridEvent for a Microsoft.Media.LiveEventIncomingDataChunkDropped event. </summary>
    public partial class MediaLiveEventIncomingDataChunkDroppedEventData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MediaLiveEventIncomingDataChunkDroppedEventData"/>. </summary>
        internal MediaLiveEventIncomingDataChunkDroppedEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MediaLiveEventIncomingDataChunkDroppedEventData"/>. </summary>
        /// <param name="timestamp"> Gets the timestamp of the data chunk dropped. </param>
        /// <param name="trackType"> Gets the type of the track (Audio / Video). </param>
        /// <param name="bitrate"> Gets the bitrate of the track. </param>
        /// <param name="timescale"> Gets the timescale of the Timestamp. </param>
        /// <param name="resultCode"> Gets the result code for fragment drop operation. </param>
        /// <param name="trackName"> Gets the name of the track for which fragment is dropped. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MediaLiveEventIncomingDataChunkDroppedEventData(string timestamp, string trackType, long? bitrate, string timescale, string resultCode, string trackName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Timestamp = timestamp;
            TrackType = trackType;
            Bitrate = bitrate;
            Timescale = timescale;
            ResultCode = resultCode;
            TrackName = trackName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the timestamp of the data chunk dropped. </summary>
        public string Timestamp { get; }
        /// <summary> Gets the type of the track (Audio / Video). </summary>
        public string TrackType { get; }
        /// <summary> Gets the bitrate of the track. </summary>
        public long? Bitrate { get; }
        /// <summary> Gets the timescale of the Timestamp. </summary>
        public string Timescale { get; }
        /// <summary> Gets the result code for fragment drop operation. </summary>
        public string ResultCode { get; }
        /// <summary> Gets the name of the track for which fragment is dropped. </summary>
        public string TrackName { get; }
    }
}
