// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> The event data for a Job output asset. </summary>
    public partial class MediaJobOutputAsset : MediaJobOutput
    {
        /// <summary> Initializes a new instance of <see cref="MediaJobOutputAsset"/>. </summary>
        /// <param name="error"> Gets the Job output error. </param>
        /// <param name="progress"> Gets the Job output progress. </param>
        /// <param name="state"> Gets the Job output state. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="error"/> is null. </exception>
        internal MediaJobOutputAsset(MediaJobError error, long progress, MediaJobState state) : base(error, progress, state)
        {
            Argument.AssertNotNull(error, nameof(error));

            OdataType = "#Microsoft.Media.JobOutputAsset";
        }

        /// <summary> Initializes a new instance of <see cref="MediaJobOutputAsset"/>. </summary>
        /// <param name="odataType"> The discriminator for derived types. </param>
        /// <param name="error"> Gets the Job output error. </param>
        /// <param name="label"> Gets the Job output label. </param>
        /// <param name="progress"> Gets the Job output progress. </param>
        /// <param name="state"> Gets the Job output state. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="assetName"> Gets the Job output asset name. </param>
        internal MediaJobOutputAsset(string odataType, MediaJobError error, string label, long progress, MediaJobState state, IDictionary<string, BinaryData> serializedAdditionalRawData, string assetName) : base(odataType, error, label, progress, state, serializedAdditionalRawData)
        {
            AssetName = assetName;
        }

        /// <summary> Initializes a new instance of <see cref="MediaJobOutputAsset"/> for deserialization. </summary>
        internal MediaJobOutputAsset()
        {
        }

        /// <summary> Gets the Job output asset name. </summary>
        public string AssetName { get; }
    }
}
