// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    public partial class MapsGeofenceGeometry : IUtf8JsonSerializable, IJsonModel<MapsGeofenceGeometry>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MapsGeofenceGeometry>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MapsGeofenceGeometry>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MapsGeofenceGeometry>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MapsGeofenceGeometry)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(DeviceId))
            {
                writer.WritePropertyName("deviceId"u8);
                writer.WriteStringValue(DeviceId);
            }
            if (Optional.IsDefined(Distance))
            {
                writer.WritePropertyName("distance"u8);
                writer.WriteNumberValue(Distance.Value);
            }
            if (Optional.IsDefined(GeometryId))
            {
                writer.WritePropertyName("geometryId"u8);
                writer.WriteStringValue(GeometryId);
            }
            if (Optional.IsDefined(NearestLat))
            {
                writer.WritePropertyName("nearestLat"u8);
                writer.WriteNumberValue(NearestLat.Value);
            }
            if (Optional.IsDefined(NearestLon))
            {
                writer.WritePropertyName("nearestLon"u8);
                writer.WriteNumberValue(NearestLon.Value);
            }
            if (Optional.IsDefined(UdId))
            {
                writer.WritePropertyName("udId"u8);
                writer.WriteStringValue(UdId);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MapsGeofenceGeometry IJsonModel<MapsGeofenceGeometry>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MapsGeofenceGeometry>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MapsGeofenceGeometry)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMapsGeofenceGeometry(document.RootElement, options);
        }

        internal static MapsGeofenceGeometry DeserializeMapsGeofenceGeometry(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string deviceId = default;
            float? distance = default;
            string geometryId = default;
            float? nearestLat = default;
            float? nearestLon = default;
            string udId = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("deviceId"u8))
                {
                    deviceId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("distance"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    distance = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("geometryId"u8))
                {
                    geometryId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("nearestLat"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    nearestLat = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("nearestLon"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    nearestLon = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("udId"u8))
                {
                    udId = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new MapsGeofenceGeometry(
                deviceId,
                distance,
                geometryId,
                nearestLat,
                nearestLon,
                udId,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<MapsGeofenceGeometry>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MapsGeofenceGeometry>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(MapsGeofenceGeometry)} does not support writing '{options.Format}' format.");
            }
        }

        MapsGeofenceGeometry IPersistableModel<MapsGeofenceGeometry>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MapsGeofenceGeometry>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMapsGeofenceGeometry(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MapsGeofenceGeometry)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MapsGeofenceGeometry>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static MapsGeofenceGeometry FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeMapsGeofenceGeometry(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
