// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Geofence event (GeofenceEntered, GeofenceExited, GeofenceResult). </summary>
    public partial class MapsGeofenceEventProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MapsGeofenceEventProperties"/>. </summary>
        /// <param name="geometries"> Lists the fence geometries that either fully contain the coordinate position or have an overlap with the searchBuffer around the fence. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="geometries"/> is null. </exception>
        internal MapsGeofenceEventProperties(IEnumerable<MapsGeofenceGeometry> geometries)
        {
            Argument.AssertNotNull(geometries, nameof(geometries));

            ExpiredGeofenceGeometryId = new ChangeTrackingList<string>();
            Geometries = geometries.ToList();
            InvalidPeriodGeofenceGeometryId = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="MapsGeofenceEventProperties"/>. </summary>
        /// <param name="expiredGeofenceGeometryId"> Lists of the geometry ID of the geofence which is expired relative to the user time in the request. </param>
        /// <param name="geometries"> Lists the fence geometries that either fully contain the coordinate position or have an overlap with the searchBuffer around the fence. </param>
        /// <param name="invalidPeriodGeofenceGeometryId"> Lists of the geometry ID of the geofence which is in invalid period relative to the user time in the request. </param>
        /// <param name="isEventPublished"> True if at least one event is published to the Azure Maps event subscriber, false if no event is published to the Azure Maps event subscriber. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MapsGeofenceEventProperties(IReadOnlyList<string> expiredGeofenceGeometryId, IReadOnlyList<MapsGeofenceGeometry> geometries, IReadOnlyList<string> invalidPeriodGeofenceGeometryId, bool? isEventPublished, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ExpiredGeofenceGeometryId = expiredGeofenceGeometryId;
            Geometries = geometries;
            InvalidPeriodGeofenceGeometryId = invalidPeriodGeofenceGeometryId;
            IsEventPublished = isEventPublished;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MapsGeofenceEventProperties"/> for deserialization. </summary>
        internal MapsGeofenceEventProperties()
        {
        }

        /// <summary> Lists of the geometry ID of the geofence which is expired relative to the user time in the request. </summary>
        public IReadOnlyList<string> ExpiredGeofenceGeometryId { get; }
        /// <summary> Lists the fence geometries that either fully contain the coordinate position or have an overlap with the searchBuffer around the fence. </summary>
        public IReadOnlyList<MapsGeofenceGeometry> Geometries { get; }
        /// <summary> Lists of the geometry ID of the geofence which is in invalid period relative to the user time in the request. </summary>
        public IReadOnlyList<string> InvalidPeriodGeofenceGeometryId { get; }
        /// <summary> True if at least one event is published to the Azure Maps event subscriber, false if no event is published to the Azure Maps event subscriber. </summary>
        public bool? IsEventPublished { get; }
    }
}
