// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Schema of the Data property of an EventGridEvent for a Microsoft.MachineLearningServices.ModelDeployed event. </summary>
    public partial class MachineLearningServicesModelDeployedEventData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MachineLearningServicesModelDeployedEventData"/>. </summary>
        /// <param name="serviceTags"> The tags of the deployed service. </param>
        /// <param name="serviceProperties"> The properties of the deployed service. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="serviceTags"/> or <paramref name="serviceProperties"/> is null. </exception>
        internal MachineLearningServicesModelDeployedEventData(IReadOnlyDictionary<string, BinaryData> serviceTags, IReadOnlyDictionary<string, BinaryData> serviceProperties)
        {
            Argument.AssertNotNull(serviceTags, nameof(serviceTags));
            Argument.AssertNotNull(serviceProperties, nameof(serviceProperties));

            ServiceTags = serviceTags;
            ServiceProperties = serviceProperties;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningServicesModelDeployedEventData"/>. </summary>
        /// <param name="serviceName"> The name of the deployed service. </param>
        /// <param name="serviceComputeType"> The compute type (e.g. ACI, AKS) of the deployed service. </param>
        /// <param name="modelIds"> A common separated list of model IDs. The IDs of the models deployed in the service. </param>
        /// <param name="serviceTags"> The tags of the deployed service. </param>
        /// <param name="serviceProperties"> The properties of the deployed service. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MachineLearningServicesModelDeployedEventData(string serviceName, string serviceComputeType, string modelIds, IReadOnlyDictionary<string, BinaryData> serviceTags, IReadOnlyDictionary<string, BinaryData> serviceProperties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ServiceName = serviceName;
            ServiceComputeType = serviceComputeType;
            ModelIds = modelIds;
            ServiceTags = serviceTags;
            ServiceProperties = serviceProperties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MachineLearningServicesModelDeployedEventData"/> for deserialization. </summary>
        internal MachineLearningServicesModelDeployedEventData()
        {
        }

        /// <summary> The name of the deployed service. </summary>
        public string ServiceName { get; }
        /// <summary> The compute type (e.g. ACI, AKS) of the deployed service. </summary>
        public string ServiceComputeType { get; }
        /// <summary> A common separated list of model IDs. The IDs of the models deployed in the service. </summary>
        public string ModelIds { get; }
        /// <summary>
        /// The tags of the deployed service.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IReadOnlyDictionary<string, BinaryData> ServiceTags { get; }
        /// <summary>
        /// The properties of the deployed service.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IReadOnlyDictionary<string, BinaryData> ServiceProperties { get; }
    }
}
