// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Event data for Microsoft.Devices.DeviceTelemetry event. </summary>
    public partial class IotHubDeviceTelemetryEventData : DeviceTelemetryEventProperties
    {
        /// <summary> Initializes a new instance of <see cref="IotHubDeviceTelemetryEventData"/>. </summary>
        /// <param name="body"> The content of the message from the device. </param>
        /// <param name="properties"> Application properties are user-defined strings that can be added to the message. These fields are optional. </param>
        /// <param name="systemProperties"> System properties help identify contents and source of the messages. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="body"/>, <paramref name="properties"/> or <paramref name="systemProperties"/> is null. </exception>
        internal IotHubDeviceTelemetryEventData(IReadOnlyDictionary<string, BinaryData> body, IReadOnlyDictionary<string, string> properties, IReadOnlyDictionary<string, string> systemProperties) : base(body, properties, systemProperties)
        {
            Argument.AssertNotNull(body, nameof(body));
            Argument.AssertNotNull(properties, nameof(properties));
            Argument.AssertNotNull(systemProperties, nameof(systemProperties));
        }

        /// <summary> Initializes a new instance of <see cref="IotHubDeviceTelemetryEventData"/>. </summary>
        /// <param name="body"> The content of the message from the device. </param>
        /// <param name="properties"> Application properties are user-defined strings that can be added to the message. These fields are optional. </param>
        /// <param name="systemProperties"> System properties help identify contents and source of the messages. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IotHubDeviceTelemetryEventData(IReadOnlyDictionary<string, BinaryData> body, IReadOnlyDictionary<string, string> properties, IReadOnlyDictionary<string, string> systemProperties, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(body, properties, systemProperties, serializedAdditionalRawData)
        {
        }

        /// <summary> Initializes a new instance of <see cref="IotHubDeviceTelemetryEventData"/> for deserialization. </summary>
        internal IotHubDeviceTelemetryEventData()
        {
        }
    }
}
