// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> EventGrid MQTT Client State. </summary>
    public readonly partial struct EventGridMQTTClientState : IEquatable<EventGridMQTTClientState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EventGridMQTTClientState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EventGridMQTTClientState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static EventGridMQTTClientState Enabled { get; } = new EventGridMQTTClientState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static EventGridMQTTClientState Disabled { get; } = new EventGridMQTTClientState(DisabledValue);
        /// <summary> Determines if two <see cref="EventGridMQTTClientState"/> values are the same. </summary>
        public static bool operator ==(EventGridMQTTClientState left, EventGridMQTTClientState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EventGridMQTTClientState"/> values are not the same. </summary>
        public static bool operator !=(EventGridMQTTClientState left, EventGridMQTTClientState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EventGridMQTTClientState"/>. </summary>
        public static implicit operator EventGridMQTTClientState(string value) => new EventGridMQTTClientState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EventGridMQTTClientState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EventGridMQTTClientState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
