// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> Event data for Microsoft.EventGrid.MQTTClientSessionConnected event. </summary>
    public partial class EventGridMQTTClientSessionConnectedEventData : EventGridMQTTClientEventData
    {
        /// <summary> Initializes a new instance of <see cref="EventGridMQTTClientSessionConnectedEventData"/>. </summary>
        internal EventGridMQTTClientSessionConnectedEventData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EventGridMQTTClientSessionConnectedEventData"/>. </summary>
        /// <param name="clientAuthenticationName">
        /// Unique identifier for the MQTT client that the client presents to the service
        /// for authentication. This case-sensitive string can be up to 128 characters
        /// long, and supports UTF-8 characters.
        /// </param>
        /// <param name="clientName"> Name of the client resource in the Event Grid namespace. </param>
        /// <param name="namespaceName"> Name of the Event Grid namespace where the MQTT client was created or updated. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="clientSessionName">
        /// Unique identifier for the MQTT client's session. This case-sensitive string can
        /// be up to 128 characters long, and supports UTF-8 characters.
        /// </param>
        /// <param name="sequenceNumber">
        /// A number that helps indicate order of MQTT client session connected or
        /// disconnected events. Latest event will have a sequence number that is higher
        /// than the previous event.
        /// </param>
        internal EventGridMQTTClientSessionConnectedEventData(string clientAuthenticationName, string clientName, string namespaceName, IDictionary<string, BinaryData> serializedAdditionalRawData, string clientSessionName, long? sequenceNumber) : base(clientAuthenticationName, clientName, namespaceName, serializedAdditionalRawData)
        {
            ClientSessionName = clientSessionName;
            SequenceNumber = sequenceNumber;
        }

        /// <summary>
        /// Unique identifier for the MQTT client's session. This case-sensitive string can
        /// be up to 128 characters long, and supports UTF-8 characters.
        /// </summary>
        public string ClientSessionName { get; }
        /// <summary>
        /// A number that helps indicate order of MQTT client session connected or
        /// disconnected events. Latest event will have a sequence number that is higher
        /// than the previous event.
        /// </summary>
        public long? SequenceNumber { get; }
    }
}
