// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Messaging.EventGrid.SystemEvents
{
    /// <summary> A portion of the properties that can be written only by the application back-end, and read by the device. </summary>
    public partial class DeviceTwinProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DeviceTwinProperties"/>. </summary>
        /// <param name="metadata"> Metadata information for the properties JSON document. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="metadata"/> is null. </exception>
        internal DeviceTwinProperties(DeviceTwinMetadata metadata)
        {
            Argument.AssertNotNull(metadata, nameof(metadata));

            Metadata = metadata;
        }

        /// <summary> Initializes a new instance of <see cref="DeviceTwinProperties"/>. </summary>
        /// <param name="metadata"> Metadata information for the properties JSON document. </param>
        /// <param name="version"> Version of device twin properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DeviceTwinProperties(DeviceTwinMetadata metadata, float? version, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Metadata = metadata;
            Version = version;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DeviceTwinProperties"/> for deserialization. </summary>
        internal DeviceTwinProperties()
        {
        }

        /// <summary> Metadata information for the properties JSON document. </summary>
        public DeviceTwinMetadata Metadata { get; }
        /// <summary> Version of device twin properties. </summary>
        public float? Version { get; }
    }
}
